function rectangularCollision({
    rectangle1,
    rectangle2
}) {
    // Use the actual collision box positions, accounting for offsets
    const rect1Left = rectangle1.attackBox.position.x;
    const rect1Right = rectangle1.attackBox.position.x + rectangle1.attackBox.width;
    const rect1Top = rectangle1.attackBox.position.y;
    const rect1Bottom = rectangle1.attackBox.position.y + rectangle1.attackBox.height;
    
    // For rectangle2, use position (which is the actual body position)
    const rect2Left = rectangle2.position.x;
    const rect2Right = rectangle2.position.x + rectangle2.width;
    const rect2Top = rectangle2.position.y;
    const rect2Bottom = rectangle2.position.y + rectangle2.height;
    
    return (
        rect1Right >= rect2Left &&
        rect1Left <= rect2Right &&
        rect1Bottom >= rect2Top &&
        rect1Top <= rect2Bottom
    );
};

function determinewinner({ player, enemy, timerId }) {
    if (timerId) {
        clearTimeout(timerId);
    }
    document.getElementById('gameStatus').style.display = 'flex';
    
    const playerName = player.name || 'Player';
    const enemyName = enemy.name || 'Enemy';
    
    if (player.health === enemy.health) {
        document.getElementById('gameStatus').innerHTML = '<span style="color: #818cf8; font-weight: bold; font-size: 24px;">Tie</span>';
    } else if (player.health < enemy.health) {
        document.getElementById('gameStatus').innerHTML = `<span style="color: #f87171; font-weight: bold; font-size: 24px;">${enemyName} Wins! 🏆</span>`;
    } else if (player.health > enemy.health) {
        document.getElementById('gameStatus').innerHTML = `<span style="color: #60a5fa; font-weight: bold; font-size: 24px;">player (${playerName}) win 🏆</span>`;
    }
}

let timer = 60;
let timerId
function decreaseTimer() {
    if (timer > 0) {
        timerId = setTimeout(decreaseTimer, 1000)
        timer--
        document.getElementById('timer').innerHTML = timer;
    };

    if (timer === 0) {
        determinewinner({ player, enemy });
    }
};
